<?php
defined('BASEPATH') or exit('No direct script access allowed');
class M_Wheel extends CI_Model
{
    public function getPrizes()
    {
        return $this->db->get('wheel_prizes')->result_array();
    }

    public function addPrize($text, $color, $usdReward, $expReward, $probability)
    {
        $insert = array(
            'text' => $text,
            'color' => $color,
            'usd_reward' => $usdReward,
            'exp_reward' => $expReward,
            'probability' => $probability
        );
        $this->db->insert('wheel_prizes', $insert);
    }
    public function updatePrize($id, $text, $color, $usdReward, $expReward, $probability)
    {
        $this->db->where('id', $id);
        $this->db->set('text', $text);
        $this->db->set('color', $color);
        $this->db->set('usd_reward', $usdReward);
        $this->db->set('exp_reward', $expReward);
        $this->db->set('probability', $probability);
        $this->db->update('wheel_prizes');
    }

    public function insertHistory($id, $amount)
    {
        $insert = array(
            'user_id' => $id,
            'amount' => $amount,
            'claim_time' => time()
        );
        $this->db->insert('wheel_history', $insert);
    }
    public function updateUser($id, $amount, $cost)
    {
        $this->db->where('id', $id);
        $this->db->set('balance', 'balance+' . $amount, FALSE);
        $this->db->set('energy', 'energy-' . $cost, FALSE);
        $this->db->set('total_earned', 'total_earned+' . $amount, FALSE);
        $this->db->set('faucet_count', 'faucet_count+1', FALSE);
        $this->db->set('faucet_count_tmp', 'faucet_count_tmp+1', FALSE);
        $this->db->set('wheel_cnt', 'wheel_cnt+1', FALSE);
        $this->db->set('wheel_claim', time());
        $this->db->set('last_active', time());
        $this->db->update('users');
    }
}
