let theWheel = new Winwheel({
  outerRadius: 150,
  innerRadius: 20,
  textFontSize: 24,
  textAlignment: "center",
  lineWidth: 2,
  numSegments: prizes.length,
  segments: prizes,
  animation: {
    type: "spinToStop",
    duration: 10,
    spins: 3,
    callbackFinished: alertPrize,
  },
  pins: {
    number: prizes.length,
    fillStyle: "silver",
    outerRadius: 4,
  },
});

function alertPrize(indicatedSegment) {
  Swal.fire({
    title: "Success",
    text: `You have won ${indicatedSegment.text} tokens`,
    icon: "success",
  }).then(() => location.reload());
}

$("#spin-button").click(function () {
  const token = $("#token").val();
  const captcha = $("#selectCaptcha").val();
  const antibotlinks = $('[name="antibotlinks"]').val();
  let captchaResult = {};
  if (captcha === "recaptchav2") {
    captchaResult = {
      "g-recaptcha-response": $('[name="g-recaptcha-response"]').val(),
    };
  } else if (captcha === "recaptchav3") {
    captchaResult = {
      recaptchav3: $("#recaptchav3Token").val(),
    };
  } else if (captcha === "hcaptcha") {
    captchaResult = {
      "h-captcha-response": $('[name="h-captcha-response"]').val(),
    };
  } else if (captcha === "solvemedia") {
    captchaResult = {
      adcopy_challenge: $('[name="adcopy_challenge"]').val(),
      adcopy_response: $('[name="adcopy_response"]').val(),
    };
  }

  const data = {
    ...captchaResult,
    token,
    captcha,
    antibotlinks,
  };

  $.post(site_url + "wheel/verify", data, function (data, status) {
    const result = JSON.parse(data);
    if (result.status !== "success") {
      Swal.fire({ title: "Error", text: result.message, icon: "error" }).then(
        () => location.reload()
      );
    } else {
      theWheel.animation.stopAngle = result["stopAngle"];
      theWheel.startAnimation();
    }
  });
});

const countDown = setInterval(() => {
  if (typeof wait !== "undefined") {
    if (wait == 0) {
      clearInterval(countDown);
      location.href = "";
    }
    let minutes = Math.floor(wait / 60);
    let seconds = wait % 60;
    $("#minute").text(minutes);
    $("#second").text(seconds);
    wait -= 1;
  }
}, 1000);
