<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Home::index');
$routes->get('maintenance', 'Maintenance::index');
$routes->post('auth/login', 'Auth::login');
$routes->get('logout', 'Auth::logout');
$routes->group('member', function($routes){
    $routes->get('dashboard', 'Member\Dashboard::index');
    $routes->get('referral', 'Member\Referral::index');
    $routes->get('faucet', 'Member\Faucet::index');
    $routes->post('faucet/claim', 'Member\Faucet::claim');
    $routes->get('shortlinks', 'Member\Shortlink::index');
    $routes->get('shortlink/view/(:num)', 'Member\Shortlink::view/$1');
    $routes->get('link/back/(:any)', 'Member\Shortlink::back/$1');
    $routes->get('adblock', 'Member\Dashboard::adblock');
});

$routes->group('admin', function($routes){
    $routes->get('login', 'Admin\Login::index');
    $routes->post('login/authenticate', 'Admin\Login::authenticate');
    $routes->get('login/logout', 'Admin\Login::logout');
    $routes->get('dashboard', 'Admin\Dashboard::index');
    
    // Users management
    $routes->get('users', 'Admin\Users::index');
    
    // Payouts management
    $routes->get('payouts', 'Admin\Payouts::index');
    
    // Settings management
    $routes->get('settings', 'Admin\Settings::index');
    $routes->post('settings/update', 'Admin\Settings::update');
    
    // Faucet management
    $routes->get('faucet', 'Admin\Faucet::index');
    $routes->post('faucet/clear', 'Admin\Faucet::clearHistory');
    
    // Shortlinks management
    $routes->get('shortlinks', 'Admin\Shortlinks::index');
    $routes->get('shortlinks/add', 'Admin\Shortlinks::add');
    $routes->post('shortlinks/add', 'Admin\Shortlinks::add');
    $routes->get('shortlinks/edit/(:num)', 'Admin\Shortlinks::edit/$1');
    $routes->post('shortlinks/edit/(:num)', 'Admin\Shortlinks::edit/$1');
    $routes->get('shortlinks/delete/(:num)', 'Admin\Shortlinks::delete/$1');
    $routes->get('shortlinks/toggle/(:num)', 'Admin\Shortlinks::toggleStatus/$1');
    $routes->get('shortlinks/claims', 'Admin\Shortlinks::claims');
});
