<?php

namespace App\Controllers\Admin;

use App\Controllers\AdminController;
use App\Models\SettingModel;

class Settings extends AdminController
{
    public function index()
    {
        $this->data['title'] = 'Site Settings';
        return $this->render_admin('admin/settings', $this->data);
    }
    
    public function update()
    {
        if ($this->request->getMethod() === 'post') {
            $settingModel = new SettingModel();
            
            // Get all POST data
            $postData = $this->request->getPost();
            
            foreach ($postData as $name => $value) {
                // Skip CSRF token
                if ($name === 'csrf_ac') {
                    continue;
                }
                
                // Hash admin password if it's being updated
                if ($name === 'admin_pass' && !empty($value)) {
                    $value = password_hash($value, PASSWORD_DEFAULT);
                }
                
                $settingModel->set('value', $value)->where('name', $name)->update();
            }
            
            $this->session->setFlashdata('msg', faucet_alert(['Settings updated successfully!'], 'success'));
            return redirect()->to('/admin/settings');
        }
        
        return redirect()->to('/admin/settings');
    }
}
