<?php

namespace App\Controllers;
use CodeIgniter\Controller;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;
use Config\Services;
use App\Models\UserModel;

class AdminController extends BaseController
{
    protected $user;

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger){
        parent::initController($request, $response, $logger);

       if (!$this->session->get('admin_logged_in')) {
			header('location: '.site_url('admin/login'));
            exit();
		}
		
    } 
        
    protected function render_admin($template, $data){
        $data['content'] = view($template, $data);
        return view('admin/template', $data);
    }
}
