<?php

namespace App\Controllers;

use App\Models\PayoutModel;

class Home extends BaseController
{
    public function index()
    {
        if(empty($this->data['setting']['currency']) || (empty($this->data['setting']['faucetpay_key']) && empty($this->data['setting']['hspay_key']))){
            $this->session->setFlashdata('msg', faucet_alert(['Complete the necessary settings to access the faucet.'], 'danger'));
            return redirect()->to(base_url('/admin/settings'));
        }
        if(!empty($this->request->getGet('r')) && empty($this->session->get('ref'))){
            $this->session->set('ref', $this->request->getGet('r'));
        }
        
        // Get last 10 withdrawals for proof
        $payoutModel = new PayoutModel();
        $this->data['withdrawals'] = $payoutModel->orderBy('time_stamp', 'DESC')->findAll(10);
        
        return view('home', $this->data);
    }
}
