<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\SettingModel;

class Maintenance extends BaseController
{
    public function index()
    {
        $settingModel = new SettingModel();
        
        // Get site settings
        $settings = $settingModel->findAll();
        $settingData = [];
        foreach ($settings as $setting) {
            $settingData[$setting['name']] = $setting['value'];
        }
        
        $data = [
            'title' => 'Site Maintenance',
            'setting' => $settingData,
            'maintenance_message' => $settingData['maintenance_message'] ?? 'We are currently performing scheduled maintenance. Please check back later.',
            'site_name' => $settingData['site_name'] ?? 'AC Lite'
        ];
        
        return view('maintenance', $data);
    }
}
