<?php

namespace App\Controllers\Member;

use App\Controllers\MemberController;
use App\Models\PayoutModel;


class Dashboard extends MemberController
{
    public function index()
    {
        $this->data['title'] = 'Dashboard';
        $payoutModel = new PayoutModel();
        $this->data['payments'] = $payoutModel->where('user_id', $this->data['user']['id'])->orderBy('time_stamp', 'DESC')->findAll(5);
        return $this->render_member('member/dashboard', $this->data);
    }

    public function adblock()
    {
        $this->data['title'] = 'AdBlock Detected';
        return view('member/adblock', $this->data);
    }

    public function maintenance()
    {
        $this->data['title'] = 'Maintenance Mode';
        return view('member/maintenance', $this->data);
    }
}

