<?php

namespace App\Controllers;
use CodeIgniter\Controller;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;
use Config\Services;
use App\Models\UserModel;
use App\Models\NotificationModel;

class MemberController extends BaseController
{
    protected $user;

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger){
        parent::initController($request, $response, $logger);

        if($this->data['setting']['maintenance'] == 'on') {
			header('location: '.site_url('maintenance'));
            exit();
		}
        if (!$this->session->get('logged_in')) {
			header('location: '.site_url('/'));
            exit();
		}else{
            $userModel = new UserModel();
            $this->data['user'] = $userModel->where('id', $this->session->get('user_id'))->first();
        }
		
    }
    protected function render_member($template, $data){
        
        $data['content'] = view($template, $data);
        return view('member/template', $data);
    }
}
