<?php

namespace App\Models;
use CodeIgniter\Model;

class FaucetHistoryModel extends Model
{
    protected $table = 'faucet_history';
    protected $primaryKey = 'id';
    protected $allowedFields = ['user_id', 'reward', 'ip', 'time_stamp'];

    public function getFaucetHistory($user_id){
        return $this->where('user_id', $user_id)->orderBy('time_stamp', 'DESC')->findAll(10);
    }

    public function addFaucetHistory($user_id, $reward, $ip){
        $data = [
            'user_id' => $user_id,
            'reward' => $reward,
            'ip' => $ip,
            'time_stamp' => date('Y-m-d H:i:s'),
        ];
        return $this->insert($data);
    }

    public function lastClaim($user_id){
        return $this->where('user_id', $user_id)->orderBy('time_stamp', 'DESC')->first();
    }

    public function getUserClaims($user_id, $ip){
        return $this
        ->groupStart()
            ->where('user_id', $user_id)
            ->orWhere('ip', $ip)
        ->groupEnd()
        ->where('time_stamp >=', date('Y-m-d 00:00:00', time()))
        ->countAllResults();
    }

}

