<?php

namespace App\Models;
use CodeIgniter\Model;

class PayoutModel extends Model
{
    protected $table = 'payouts';
    protected $primaryKey = 'id';
    protected $allowedFields = ['user_id', 'address', 'currency', 'type', 'amount', 'amount_currency', 'time_stamp'];

    public function getPayout($user_id = null){
        if($user_id){
            return $this->where('user_id', $user_id)->orderBy('time_stamp', 'DESC')->findAll(10);
        }
        return $this->orderBy('time_stamp', 'DESC')->findAll(10);
    }

    public function addPayout($user_id, $address, $currency, $type, $amount, $amount_currency){
        $data = [
            'user_id' => $user_id,
            'address' => $address,
            'currency' => $currency,
            'type' => $type,
            'amount' => $amount,
            'amount_currency' => $amount_currency,
            'time_stamp' => date('Y-m-d H:i:s'),
        ];
        return $this->insert($data);
    }

    public function getPayoutByAddress($address){
        return $this->where('address', $address)->orderBy('time_stamp', 'DESC')->first();
    }
    
    
}
