<?php

namespace App\Models;
use CodeIgniter\Model;

class ShortlinkHistoryModel extends Model
{
    protected $table = 'link_history';
    protected $primaryKey = 'id';
    protected $allowedFields = ['link_id', 'user_id', 'ip', 'url', 'reward', 'hash', 'time_stamp'];

    public function getShortlinkHistory($link_id = null){
        if($link_id){
            return $this->where('link_id', $link_id)->orderBy('time_stamp', 'DESC')->findAll();
        }
        return $this->orderBy('time_stamp', 'DESC')->findAll(10);
    }

    public function addShortlinkHistory($link_id, $user_id, $ip, $url, $reward, $hash){
        $data = [
            'link_id' => $link_id,
            'user_id' => $user_id,
            'ip' => $ip,
            'url' => $url,
            'reward' => $reward,
            'hash' => $hash,
            'time_stamp' => date('Y-m-d H:i:s'),
        ];
        return $this->insert($data);
    }

    public function lastClaim($user_id){
        return $this->where('user_id', $user_id)->orderBy('time_stamp', 'DESC')->first();
    }

    public function getLastClaim($user_id){
        return $this->where('user_id', $user_id)->orderBy('time_stamp', 'DESC')->first();
    }
}
