<?php

namespace App\Models;
use CodeIgniter\Model;

class ShortlinkModel extends Model
{
    protected $table = 'shortlink';
    protected $primaryKey = 'id';
    protected $allowedFields = ['id', 'name', 'reward', 'view', 'api_key', 'priority'];

    public function getShortlink($id = null){
        if($id){
            return $this->where('id', $id)->first();
        }
        return $this->findAll();
    }

    public function getShortlinkByName($name){
        return $this->where('name', $name)->first();
    }
}
