<div class="admin-dashboard">
    <?php if ($update_available): ?>
    <div class="alert alert-warning">
        <i class="fas fa-exclamation-triangle"></i> A new version of this script is available. Please update your script by going on the official <a href="https://altercode.net">AlterCode</a> website.
    </div>
    <?php endif; ?>
    <!-- Dashboard Stats -->
    <div class="row mb-4">
        <div class="col-12 col-lg-6 col-xxl-3 mb-3">
            <div class="admin-stat-card">
                <div class="stat-icon">
                    <i class="fas fa-users"></i>
                </div>
                <div class="stat-content">
                    <h3><?= number_format($totalUsers) ?></h3>
                    <p>Total Users</p>
                </div>
            </div>
        </div>
        
        <div class="col-12 col-lg-6 col-xxl-3 mb-3">
            <div class="admin-stat-card">
                <div class="stat-icon">
                    <i class="fas fa-user-check"></i>
                </div>
                <div class="stat-content">
                    <h3><?= number_format($activeUsers) ?></h3>
                    <p>Active Users (7 days)</p>
                </div>
            </div>
        </div>
        
        <div class="col-12 col-lg-6 col-xxl-3 mb-3">
            <div class="admin-stat-card">
                <div class="stat-icon">
                    <i class="fas fa-user-plus"></i>
                </div>
                <div class="stat-content">
                    <h3><?= number_format($newUsersToday) ?></h3>
                    <p>New Users Today</p>
                </div>
            </div>
        </div>
        
        <div class="col-12 col-lg-6 col-xxl-3 mb-3">
            <div class="admin-stat-card">
                <div class="stat-icon">
                    <i class="fas fa-wallet"></i>
                </div>
                <div class="stat-content">
                    <h3><?= number_format($totalPayouts) ?></h3>
                    <p>Total Payouts</p>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Recent Activity -->
    <div class="row">
        <div class="col-12 col-lg-6 mb-4">
            <div class="admin-card">
                <div class="card-header">
                    <h5><i class="fas fa-users me-2"></i>Recent Users</h5>
                </div>
                <div class="card-body">
                    <?php if (!empty($recentUsers)): ?>
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>User ID</th>
                                    <th>Address</th>
                                    <th>Joined</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($recentUsers as $user): ?>
                                <tr>
                                    <td><?= esc($user['id']) ?></td>
                                    <td><?= esc($user['email']) ?></td>
                                    <td><?= timeSpan($user['registered_date']) ?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php else: ?>
                    <p class="text-muted">No users found.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <div class="col-12 col-lg-6 mb-4">
            <div class="admin-card">
                <div class="card-header">
                    <h5><i class="fas fa-wallet me-2"></i>Recent Payouts</h5>
                </div>
                <div class="card-body">
                    <?php if (!empty($recentPayouts)): ?>
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Type</th>
                                    <th>Amount</th>
                                    <th>Currency</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($recentPayouts as $payout): ?>
                                <tr>
                                    <td>
                                        <span class="badge bg-primary"><?= ucfirst($payout['type']) ?></span>
                                    </td>
                                    <td><?= format_amount($payout['amount_currency'], 8) ?></td>
                                    <td><?= $payout['currency'] ?></td>
                                    <td><?= timeSpan($payout['time_stamp']) ?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php else: ?>
                    <p class="text-muted">No payouts found.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

