<div class="container-fluid">
        <!-- Page Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <h1 class="h3 mb-0"><?= $title ?></h1>
                    <form method="POST" action="<?= base_url('admin/faucet/clear') ?>" class="d-inline">
                        <?= csrf_field() ?>
                        <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to clear all faucet history? This action cannot be undone.')">
                            <i class="fas fa-trash me-1"></i>Clear History
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <!-- Statistics Cards -->
        <div class="row mb-4">
            <div class="col-12 col-sm-6 col-md-4 mb-3">
                <div class="admin-stat-card gradient">
                    <div class="stat-icon">
                        <i class="fas fa-tint"></i>
                    </div>
                    <div class="stat-content">
                        <h3><?= number_format($stats['total_claims']) ?></h3>
                        <p>Total Claims</p>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-md-4 mb-3">
                <div class="admin-stat-card gradient">
                    <div class="stat-icon">
                        <i class="fas fa-calendar-day"></i>
                    </div>
                    <div class="stat-content">
                        <h3><?= number_format($stats['today_claims']) ?></h3>
                        <p>Today's Claims</p>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-6 col-md-4 mb-3">
                <div class="admin-stat-card gradient">
                    <div class="stat-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="stat-content">
                        <h3><?= number_format($stats['unique_users']) ?></h3>
                        <p>Unique Users</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Search and Filters -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="admin-card">
                    <div class="card-body">
                        <form method="GET" action="<?= base_url('admin/faucet') ?>" class="row g-3">
                            <div class="col-md-4">
                                <input type="text" class="form-control" name="search" placeholder="Search by email or ID..." 
                                       value="<?= esc($filters['search']) ?>">
                            </div>
                            <div class="col-md-2">
                                <select class="form-select" name="sort">
                                    <option value="id" <?= $filters['sort'] === 'id' ? 'selected' : '' ?>>ID</option>
                                    <option value="created_at" <?= $filters['sort'] === 'created_at' ? 'selected' : '' ?>>Date</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <select class="form-select" name="order">
                                    <option value="DESC" <?= $filters['order'] === 'DESC' ? 'selected' : '' ?>>Descending</option>
                                    <option value="ASC" <?= $filters['order'] === 'ASC' ? 'selected' : '' ?>>Ascending</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="fas fa-search me-1"></i>Search
                                </button>
                            </div>
                            <div class="col-md-2">
                                <a href="<?= base_url('admin/faucet') ?>" class="btn btn-secondary w-100">
                                    <i class="fas fa-refresh me-1"></i>Reset
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Faucet History Table -->
        <div class="admin-card">
            <div class="card-header">
                <h5><i class="fas fa-list me-2"></i>Faucet Claim History</h5>
            </div>
            <div class="card-body">
                <?php if (!empty($faucet_history)): ?>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>User</th>
                                <th>Reward</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($faucet_history as $claim): ?>
                            <tr>
                                <td><?= esc($claim['id']) ?></td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div>
                                            <div class="fw-bold"><?= esc($claim['user_email'] ?? 'Unknown') ?></div>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <span class="badge bg-success"><?= format_amount($claim['reward'], 8) ?> USD</span>
                                </td>
                                <td><?= date('M j, Y H:i', strtotime($claim['time_stamp'])) ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <?php if ($pagination['total_pages'] > 1): ?>
                <nav aria-label="Faucet history pagination">
                    <ul class="pagination justify-content-center">
                        <?php if ($pagination['current_page'] > 1): ?>
                        <li class="page-item">
                            <a class="page-link" href="<?= current_url() ?>?<?= http_build_query(array_merge($filters, ['page' => $pagination['current_page'] - 1])) ?>">Previous</a>
                        </li>
                        <?php endif; ?>
                        
                        <?php for ($i = 1; $i <= $pagination['total_pages']; $i++): ?>
                        <li class="page-item <?= $i == $pagination['current_page'] ? 'active' : '' ?>">
                            <a class="page-link" href="<?= current_url() ?>?<?= http_build_query(array_merge($filters, ['page' => $i])) ?>"><?= $i ?></a>
                        </li>
                        <?php endfor; ?>
                        
                        <?php if ($pagination['current_page'] < $pagination['total_pages']): ?>
                        <li class="page-item">
                            <a class="page-link" href="<?= current_url() ?>?<?= http_build_query(array_merge($filters, ['page' => $pagination['current_page'] + 1])) ?>">Next</a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </nav>
                <?php endif; ?>
                
                <?php else: ?>
                <div class="text-center py-5">
                    <i class="fas fa-tint fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">No faucet claims found</h5>
                    <p class="text-muted">No faucet claims match your search criteria.</p>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

