<div class="container-fluid">
        <!-- Page Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <h1 class="h3 mb-0"><?= $title ?></h1>
                </div>
            </div>
        </div>

        <!-- Statistics Cards -->
        <div class="row mb-4">
            <div class="col-12 col-lg-6 col-xxl-3 mb-3">
                <div class="admin-stat-card gradient">
                    <div class="stat-icon">
                        <i class="fas fa-money-bill-wave"></i>
                    </div>
                    <div class="stat-content">
                        <h3><?= number_format($stats['total_payouts']) ?></h3>
                        <p>Total Payouts</p>
                    </div>
                </div>
            </div>
            <div class="col-12 col-lg-6 col-xxl-3 mb-3">
                <div class="admin-stat-card gradient">
                    <div class="stat-icon">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                    <div class="stat-content">
                        <h3><?= format_amount($stats['total_amount'], 8) ?></h3>
                        <p>Total Amount</p>
                    </div>
                </div>
            </div>
            <div class="col-12 col-lg-6 col-xxl-3 mb-3">
                <div class="admin-stat-card gradient">
                    <div class="stat-icon">
                        <i class="fas fa-calendar-day"></i>
                    </div>
                    <div class="stat-content">
                        <h3><?= number_format($stats['today_payouts']) ?></h3>
                        <p>Today's Payouts</p>
                    </div>
                </div>
            </div>
            <div class="col-12 col-lg-6 col-xxl-3 mb-3">
                <div class="admin-stat-card gradient">
                    <div class="stat-icon">
                        <i class="fas fa-coins"></i>
                    </div>
                    <div class="stat-content">
                        <h3><?= format_amount($stats['today_amount'], 8) ?></h3>
                        <p>Today's Amount</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Search and Filters -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="admin-card">
                    <div class="card-body">
                        <form method="GET" action="<?= base_url('admin/payouts') ?>" class="row g-3">
                            <div class="col-md-4">
                                <input type="text" class="form-control" name="search" placeholder="Search by address, email, or ID..." 
                                       value="<?= esc($filters['search']) ?>">
                            </div>
                            <div class="col-md-2">
                                <select class="form-select" name="sort">
                                    <option value="id" <?= $filters['sort'] === 'id' ? 'selected' : '' ?>>ID</option>
                                    <option value="amount" <?= $filters['sort'] === 'amount' ? 'selected' : '' ?>>Amount</option>
                                    <option value="created_at" <?= $filters['sort'] === 'created_at' ? 'selected' : '' ?>>Date</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <select class="form-select" name="order">
                                    <option value="DESC" <?= $filters['order'] === 'DESC' ? 'selected' : '' ?>>Descending</option>
                                    <option value="ASC" <?= $filters['order'] === 'ASC' ? 'selected' : '' ?>>Ascending</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="fas fa-search me-1"></i>Search
                                </button>
                            </div>
                            <div class="col-md-2">
                                <a href="<?= base_url('admin/payouts') ?>" class="btn btn-secondary w-100">
                                    <i class="fas fa-refresh me-1"></i>Reset
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Payouts Table -->
        <div class="admin-card">
            <div class="card-header">
                <h5><i class="fas fa-list me-2"></i>Payouts History</h5>
            </div>
            <div class="card-body">
                <?php if (!empty($payouts)): ?>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>User</th>
                                <th>Amount</th>
                                <th>Currency</th>
                                <th>Type</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($payouts as $payout): ?>
                            <tr>
                                <td><?= esc($payout['id']) ?></td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div>
                                            <div class="fw-bold"><?= esc($payout['address'] ?? 'Unknown') ?></div>
                                        </div>
                                    </div>
                                </td>
                                <td><?= format_amount($payout['amount_currency'], 8) ?></td>
                                <td>
                                    <span class="badge bg-primary"><?= esc($payout['currency']) ?></span>
                                </td>
                                <td>
                                    <span class="badge bg-<?= $payout['type'] === 'faucet' ? 'success' : ($payout['type'] === 'shortlink' ? 'info' : 'warning') ?>">
                                        <?= ucfirst(esc($payout['type'])) ?>
                                    </span>
                                </td>
                                <td><?= date('M j, Y H:i', strtotime($payout['time_stamp'])) ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <?php if ($pagination['total_pages'] > 1): ?>
                <nav aria-label="Payouts pagination">
                    <ul class="pagination justify-content-center">
                        <?php if ($pagination['current_page'] > 1): ?>
                        <li class="page-item">
                            <a class="page-link" href="<?= current_url() ?>?<?= http_build_query(array_merge($filters, ['page' => $pagination['current_page'] - 1])) ?>">Previous</a>
                        </li>
                        <?php endif; ?>
                        
                        <?php for ($i = 1; $i <= $pagination['total_pages']; $i++): ?>
                        <li class="page-item <?= $i == $pagination['current_page'] ? 'active' : '' ?>">
                            <a class="page-link" href="<?= current_url() ?>?<?= http_build_query(array_merge($filters, ['page' => $i])) ?>"><?= $i ?></a>
                        </li>
                        <?php endfor; ?>
                        
                        <?php if ($pagination['current_page'] < $pagination['total_pages']): ?>
                        <li class="page-item">
                            <a class="page-link" href="<?= current_url() ?>?<?= http_build_query(array_merge($filters, ['page' => $pagination['current_page'] + 1])) ?>">Next</a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </nav>
                <?php endif; ?>
                
                <?php else: ?>
                <div class="text-center py-5">
                    <i class="fas fa-money-bill-wave fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">No payouts found</h5>
                    <p class="text-muted">No payouts match your search criteria.</p>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

