<div class="container-fluid">
        <!-- Page Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <h1 class="h3 mb-0"><?= $title ?></h1>
                </div>
            </div>
        </div>
        <?php if (session()->getFlashdata('msg')): ?>
            <?= session()->getFlashdata('msg') ?>
        <?php endif; ?>
        <!-- Settings Form -->
        <div class="row">
            <div class="col-12">
                <div class="admin-card">
                    <div class="card-header">
                        <h5><i class="fas fa-cog me-2"></i>Site Configuration</h5>
                    </div>
                    <div class="card-body">

                        <form method="POST" action="<?= base_url('admin/settings/update') ?>">
                            <?= csrf_field() ?>
                            
                            <div class="row">
                                <!-- General Settings -->
                                <div class="col-lg-6">
                                    <h6 class="text-primary mb-3">General Settings</h6>
                                    
                                    <div class="mb-3">
                                        <label for="site_name" class="form-label">Site Name</label>
                                        <input type="text" class="form-control" id="site_name" name="site_name" 
                                               value="<?= esc($setting['site_name'] ?? '') ?>">
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="site_desc" class="form-label">Site Description</label>
                                        <textarea class="form-control" id="site_desc" name="site_desc" rows="3"><?= esc($setting['site_desc'] ?? '') ?></textarea>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="maintenance" class="form-label">Maintenance Mode</label>
                                        <select class="form-select" id="maintenance" name="maintenance">
                                            <option value="off" <?= ($setting['maintenance'] ?? 'off') === 'off' ? 'selected' : '' ?>>Off</option>
                                            <option value="on" <?= ($setting['maintenance'] ?? 'off') === 'on' ? 'selected' : '' ?>>On</option>
                                        </select>
                                    </div>
                                </div>

                                <!-- Captcha Settings -->
                                <div class="col-lg-6">
                                    <h6 class="text-primary mb-3">Captcha Settings</h6>
                                    
                                    <div class="mb-3">
                                        <label for="captcha" class="form-label">Captcha Type</label>
                                        <select class="form-select" id="captcha" name="captcha">
                                            <option value="" <?= empty($setting['captcha']) ? 'selected' : '' ?>>None</option>
                                            <option value="recaptcha" <?= ($setting['captcha'] ?? '') === 'recaptcha' ? 'selected' : '' ?>>reCAPTCHA</option>
                                            <option value="hcaptcha" <?= ($setting['captcha'] ?? '') === 'hcaptcha' ? 'selected' : '' ?>>hCaptcha</option>
                                            <option value="turnstile" <?= ($setting['captcha'] ?? '') === 'turnstile' ? 'selected' : '' ?>>Turnstile</option>
                                        </select>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="captcha_key" class="form-label">Captcha Site Key</label>
                                        <input type="text" class="form-control" id="captcha_key" name="captcha_key" 
                                               value="<?= esc($setting['captcha_key'] ?? '') ?>">
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="captcha_secret" class="form-label">Captcha Secret Key</label>
                                        <input type="text" class="form-control" id="captcha_secret" name="captcha_secret" 
                                               value="<?= esc($setting['captcha_secret'] ?? '') ?>">
                                    </div>
                                </div>

                                <!-- Referral Settings -->
                                <div class="col-lg-6">
                                    <h6 class="text-primary mb-3">Referral Settings</h6>
                                    
                                    <div class="mb-3">
                                        <label for="ref_bonus" class="form-label">Referral Bonus (%)</label>
                                        <input type="number" step="0.1" class="form-control" id="ref_bonus" name="ref_bonus" 
                                               value="<?= esc($setting['ref_bonus'] ?? '10') ?>">
                                    </div>
                                </div>

                                 <!-- FaucetPay Settings -->
                                 <div class="col-lg-6">
                                    <h6 class="text-primary mb-3">Wallet Settings</h6>
                                    
                                    <div class="mb-3">
                                        <label for="faucetpay_key" class="form-label">FaucetPay API Key</label>
                                        <input type="text" class="form-control" id="faucetpay_key" name="faucetpay_key" 
                                               value="<?= esc($setting['faucetpay_key'] ?? '') ?>">
                                    </div>

                                    <div class="mb-3">
                                        <label for="faucetpay_key" class="form-label">Hspay API Key</label>
                                        <input type="text" class="form-control" id="hspay_key" name="hspay_key" 
                                               value="<?= esc($setting['hspay_key'] ?? '') ?>">
                                    </div>
                                </div>
                            </div>

                            <div class="text-end">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save me-1"></i>Save Settings
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- wallet setting -->

        <div class="row mb-4">
            <div class="col-12">
                <div class="admin-card">
                    <div class="card-header">
                        <h5><i class="fas fa-faucet me-2"></i>Payment Settings</h5>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="<?= base_url('admin/settings/update') ?>">
                            <div class="row">
                                <label class="form-label">Microwallet</label>
                                <div class="mb-3 col-9">
                                    <select class="form-select" id="microwallet" name="microwallet">
                                        <option value="faucetpay" <?= $setting['microwallet'] == 'faucetpay' ? 'selected' : '' ?>>Faucetpay</option>
                                        <option value="hspay" <?= $setting['microwallet'] == 'hspay' ? 'selected' : '' ?>>Hspay</option>
                                    </select>
                                </div>
                                <div class="col-3">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save me-1"></i>Change Microwallet
                                    </button>
                                </div>
                            </div>
                        </form>
                        <form method="POST" action="<?= base_url('admin/settings/update') ?>">
                            <?= csrf_field() ?>
                            
                            <div class="row">
                                <div class="mb-3">
                                    <label class="form-label">Enabled Currencies</label>
                                    <div class="border rounded p-3">
                                        <div class="row">
                                            <?php 
                                            $availableCurrencies = currency_list($setting['microwallet']);
                                            $selectedCurrency = $setting['currency'] ?? 'BTC';
                                            
                                            foreach ($availableCurrencies as $code => $name): 
                                                $checked = ($code == $selectedCurrency) ? 'checked' : '';
                                            ?>
                                                <div class="col-sm-6 col-lg-3 mb-2">
                                                    <input class="btn-check" type="radio" name="currency" value="<?= $code ?>" id="currency_<?= $code ?>" <?= $checked ?>>
                                                    <label class="btn btn-outline-primary btn-sm w-100 d-flex align-items-center" for="currency_<?= $code ?>">
                                                        <img src="<?= base_url('assets/images/currency/' . strtolower($code) . '.png') ?>" alt="<?= $code ?>" class="me-2" style="width: 20px; height: 20px;" onerror="this.style.display='none'">
                                                        <div>
                                                            <strong><?= $code ?></strong><br>
                                                            <small><?= $name ?></small>
                                                        </div>
                                                    </label>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                    <div class="form-text">Select the currencies you want to enable for users</div>
                                </div>           
                            </div>
                            
                            <div class="text-end">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save me-1"></i>Save Wallet Settings
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Faucet Settings Card -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="admin-card">
                    <div class="card-header">
                        <h5><i class="fas fa-faucet me-2"></i>Faucet Settings</h5>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="<?= base_url('admin/settings/update') ?>">
                            <?= csrf_field() ?>
                            
                            <div class="row">
                                <div class="col-lg-3">
                                    <div class="mb-3">
                                        <label for="faucet_status" class="form-label">Faucet Status</label>
                                        <select class="form-select" id="faucet_status" name="faucet_status">
                                            <option value="off" <?= ($setting['faucet_status'] ?? 'on') === 'off' ? 'selected' : '' ?>>Off</option>
                                            <option value="on" <?= ($setting['faucet_status'] ?? 'on') === 'on' ? 'selected' : '' ?>>On</option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-lg-3">
                                    <div class="mb-3">
                                        <label for="faucet_reward" class="form-label">Faucet Reward (USD)</label>
                                        <input type="number" step="0.00001" class="form-control" id="faucet_reward" name="faucet_reward" 
                                               value="<?= esc($setting['faucet_reward']) ?>">
                                    </div>
                                </div>
                                
                                <div class="col-lg-3">
                                    <div class="mb-3">
                                        <label for="faucet_timer" class="form-label">Faucet Timer (minutes)</label>
                                        <input type="number" class="form-control" id="faucet_timer" name="faucet_timer" 
                                               value="<?= esc($setting['faucet_timer']) ?>">
                                    </div>
                                </div>

                                <div class="col-lg-3">
                                    <div class="mb-3">
                                        <label for="faucet_limit" class="form-label">Faucet daily limit</label>
                                        <input type="number" class="form-control" id="faucet_limit" name="faucet_limit" 
                                               value="<?= esc($setting['faucet_limit']) ?>">
                                    </div>
                                </div>
                            </div>
                            
                            <div class="text-end">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save me-1"></i>Save Faucet Settings
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Shortlink Settings Card -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="admin-card">
                    <div class="card-header">
                        <h5><i class="fas fa-link me-2"></i>Shortlink Settings</h5>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="<?= base_url('admin/settings/update') ?>">
                            <?= csrf_field() ?>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="shortlink_status" class="form-label">Shortlink Status</label>
                                        <select class="form-select" id="shortlink_status" name="shortlink_status">
                                            <option value="off" <?= ($setting['shortlink_status'] ?? 'on') === 'off' ? 'selected' : '' ?>>Off</option>
                                            <option value="on" <?= ($setting['shortlink_status'] ?? 'on') === 'on' ? 'selected' : '' ?>>On</option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="sl_timer" class="form-label">Shortlink Timer (seconds)</label>
                                        <input type="number" class="form-control" id="sl_timer" name="sl_timer" 
                                               value="<?= esc($setting['sl_timer'] ?? '') ?>">
                                    </div>
                                </div>
                            </div>
                            
                            <div class="text-end">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save me-1"></i>Save Shortlink Settings
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Admin Settings Card -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="admin-card">
                    <div class="card-header">
                        <h5><i class="fas fa-user-shield me-2"></i>Admin Settings</h5>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="<?= base_url('admin/settings/update') ?>">
                            <?= csrf_field() ?>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="admin_user" class="form-label">Admin Username</label>
                                        <input type="text" class="form-control" id="admin_user" name="admin_user" 
                                               value="<?= esc($setting['admin_user'] ?? 'admin') ?>">
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="admin_pass" class="form-label">Admin Password</label>
                                        <input type="password" class="form-control" id="admin_pass" name="admin_pass" 
                                               placeholder="Leave blank to keep current password">
                                        <div class="form-text">Leave blank to keep current password</div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="text-end">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save me-1"></i>Save Admin Settings
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Advertisement Settings Card -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="admin-card">
                    <div class="card-header">
                        <h5><i class="fas fa-ad me-2"></i>Advertisement Settings</h5>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="<?= base_url('admin/settings/update') ?>">
                            <?= csrf_field() ?>
                            
                            <div class="row">
                                <!-- Home & Dashboard Ads -->
                                <div class="col-md-6">
                                    <h6 class="text-primary mb-3">Home & Dashboard Ads</h6>
                                    
                                    <div class="mb-3">
                                        <label for="home_top_ad" class="form-label">Home Top Ad</label>
                                        <textarea class="form-control" id="home_top_ad" name="home_top_ad" rows="3"><?= esc($setting['home_top_ad'] ?? '') ?></textarea>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="home_bottom_ad" class="form-label">Home Bottom Ad</label>
                                        <textarea class="form-control" id="home_bottom_ad" name="home_bottom_ad" rows="3"><?= esc($setting['home_bottom_ad'] ?? '') ?></textarea>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="dashboard_top_ad" class="form-label">Dashboard Top Ad</label>
                                        <textarea class="form-control" id="dashboard_top_ad" name="dashboard_top_ad" rows="3"><?= esc($setting['dashboard_top_ad'] ?? '') ?></textarea>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="dashboard_bottom_ad" class="form-label">Dashboard Bottom Ad</label>
                                        <textarea class="form-control" id="dashboard_bottom_ad" name="dashboard_bottom_ad" rows="3"><?= esc($setting['dashboard_bottom_ad'] ?? '') ?></textarea>
                                    </div>
                                </div>
                                
                                <!-- Faucet Ads -->
                                <div class="col-md-6">
                                    <h6 class="text-primary mb-3">Faucet Advertisement Settings</h6>
                                    
                                    <div class="mb-3">
                                        <label for="faucet_top_ad" class="form-label">Faucet Top Ad</label>
                                        <textarea class="form-control" id="faucet_top_ad" name="faucet_top_ad" rows="3"><?= esc($setting['faucet_top_ad'] ?? '') ?></textarea>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="faucet_bottom_ad" class="form-label">Faucet Bottom Ad</label>
                                        <textarea class="form-control" id="faucet_bottom_ad" name="faucet_bottom_ad" rows="3"><?= esc($setting['faucet_bottom_ad'] ?? '') ?></textarea>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="faucet_square_ad" class="form-label">Faucet Square Ad</label>
                                        <textarea class="form-control" id="faucet_square_ad" name="faucet_square_ad" rows="3"><?= esc($setting['faucet_square_ad'] ?? '') ?></textarea>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <!-- Shortlink Ads -->
                                <div class="col-md-6">
                                    <h6 class="text-primary mb-3">Shortlink Advertisement Settings</h6>
                                    
                                    <div class="mb-3">
                                        <label for="sl_top_ad" class="form-label">Shortlink Top Ad</label>
                                        <textarea class="form-control" id="sl_top_ad" name="sl_top_ad" rows="3"><?= esc($setting['sl_top_ad'] ?? '') ?></textarea>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="sl_bottom_ad" class="form-label">Shortlink Bottom Ad</label>
                                        <textarea class="form-control" id="sl_bottom_ad" name="sl_bottom_ad" rows="3"><?= esc($setting['sl_bottom_ad'] ?? '') ?></textarea>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="sl_square_ad" class="form-label">Shortlink Square Ad</label>
                                        <textarea class="form-control" id="sl_square_ad" name="sl_square_ad" rows="3"><?= esc($setting['sl_square_ad'] ?? '') ?></textarea>
                                    </div>
                                </div>
                                
                                <!-- Referral Ads -->
                                <div class="col-md-6">
                                    <h6 class="text-primary mb-3">Referral Advertisement Settings</h6>
                                    
                                    <div class="mb-3">
                                        <label for="ref_top_ad" class="form-label">Referral Top Ad</label>
                                        <textarea class="form-control" id="ref_top_ad" name="ref_top_ad" rows="3"><?= esc($setting['ref_top_ad'] ?? '') ?></textarea>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="ref_bottom_ad" class="form-label">Referral Bottom Ad</label>
                                        <textarea class="form-control" id="ref_bottom_ad" name="ref_bottom_ad" rows="3"><?= esc($setting['ref_bottom_ad'] ?? '') ?></textarea>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="text-end">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save me-1"></i>Save Advertisement Settings
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

