<div class="container-fluid">
        <!-- Page Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <h1 class="h3 mb-0"><?= $title ?></h1>
                    <a href="<?= base_url('admin/shortlinks') ?>" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-1"></i>Back to Shortlinks
                    </a>
                </div>
            </div>
        </div>

        <!-- Shortlink Form -->
        <div class="row">
            <div class="col-12">
                <div class="admin-card">
                    <div class="card-header">
                        <h5><i class="fas fa-<?= isset($shortlink) ? 'edit' : 'plus' ?> me-2"></i><?= isset($shortlink) ? 'Edit' : 'Add' ?> Shortlink</h5>
                    </div>
                    <div class="card-body">
                        <?php if (session()->getFlashdata('success')): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <?= session()->getFlashdata('success') ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?>

                        <?php if (session()->getFlashdata('error')): ?>
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <?= session()->getFlashdata('error') ?>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?>

                        <form method="POST" action="<?= isset($shortlink) ? base_url('admin/shortlinks/edit/' . $shortlink['id']) : base_url('admin/shortlinks/add') ?>">
                            <?= csrf_field() ?>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="title" class="form-label">Name <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="title" name="title" 
                                               value="<?= esc($shortlink['name'] ?? '') ?>" required>
                                        <div class="form-text">A descriptive name for this shortlink</div>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="reward" class="form-label">Reward (USD) <span class="text-danger">*</span></label>
                                        <input type="number" step="0.000001" class="form-control" id="reward" name="reward" 
                                               value="<?= esc($shortlink['reward'] ?? '') ?>" required>
                                        <div class="form-text">Reward amount in USD</div>
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="views" class="form-label">Views Required</label>
                                        <input type="number" class="form-control" id="views" name="views" 
                                               value="<?= esc($shortlink['view'] ?? '1') ?>" min="1">
                                        <div class="form-text">Number of views required to complete</div>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="priority" class="form-label">Priority</label>
                                        <input type="number" class="form-control" id="priority" name="priority" 
                                               value="<?= esc($shortlink['priority'] ?? '1') ?>" min="1">
                                        <div class="form-text">Priority level (higher number = higher priority)</div>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="api_key" class="form-label">API Key</label>
                                        <input type="text" class="form-control" id="api_key" name="api_key" 
                                               value="<?= esc($shortlink['api_key'] ?? '') ?>">
                                        <div class="form-text">Optional API key for this shortlink</div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12">
                                    <div class="d-flex justify-content-end gap-2">
                                        <a href="<?= base_url('admin/shortlinks') ?>" class="btn btn-secondary">
                                            <i class="fas fa-times me-1"></i>Cancel
                                        </a>
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fas fa-save me-1"></i><?= isset($shortlink) ? 'Update' : 'Create' ?> Shortlink
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

