<div class="container-fluid">
        <!-- Page Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <h1 class="h3 mb-0"><?= $title ?></h1>
                    <div class="btn-group">
                        <a href="<?= base_url('admin/shortlinks/claims') ?>" class="btn btn-info">
                            <i class="fas fa-mouse-pointer me-1"></i>View Claims
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Search and Filters -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="admin-card">
                    <div class="card-body">
                        <form method="GET" action="<?= base_url('admin/shortlinks') ?>" class="row g-3">
                            <div class="col-md-4">
                                <input type="text" class="form-control" name="search" placeholder="Search by name or ID..." 
                                       value="<?= esc($filters['search']) ?>">
                            </div>
                            <div class="col-md-2">
                                <select class="form-select" name="sort">
                                    <option value="id" <?= $filters['sort'] === 'id' ? 'selected' : '' ?>>ID</option>
                                    <option value="name" <?= $filters['sort'] === 'name' ? 'selected' : '' ?>>Name</option>
                                    <option value="reward" <?= $filters['sort'] === 'reward' ? 'selected' : '' ?>>Reward</option>
                                    <option value="priority" <?= $filters['sort'] === 'priority' ? 'selected' : '' ?>>Priority</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <select class="form-select" name="order">
                                    <option value="DESC" <?= $filters['order'] === 'DESC' ? 'selected' : '' ?>>Descending</option>
                                    <option value="ASC" <?= $filters['order'] === 'ASC' ? 'selected' : '' ?>>Ascending</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="fas fa-search me-1"></i>Search
                                </button>
                            </div>
                            <div class="col-md-2">
                                <a href="<?= base_url('admin/shortlinks') ?>" class="btn btn-secondary w-100">
                                    <i class="fas fa-refresh me-1"></i>Reset
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Add Shortlink Form -->
        <div class="admin-card mb-4">
            <div class="card-header">
                <h5><i class="fas fa-plus me-2"></i>Add New Shortlink</h5>
            </div>
            <div class="card-body">
                <?php if (session()->getFlashdata('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?= session()->getFlashdata('success') ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
                
                <?php if (session()->getFlashdata('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <?= session()->getFlashdata('error') ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
                <form method="POST" action="<?= base_url('admin/shortlinks/add') ?>">
                    <?= csrf_field() ?>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-4">
                                <label for="title" class="form-label">Name</label>
                                <input type="text" class="form-control" id="title" name="title" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="api_key" class="form-label">Api url <small>eg: https://example.com/api?api=your_api_key&url={url} (replace only your api key)</small></label>
                                <input type="text" class="form-control" id="api_key" name="api_key" placeholder="">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="reward" class="form-label">Reward (USD)</label>
                                <input type="number" class="form-control" id="reward" name="reward" step="0.000001" min="0" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="views" class="form-label">Views</label>
                                <input type="number" class="form-control" id="views" name="views" min="0" value="0">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="priority" class="form-label">Priority</label>
                                <input type="number" class="form-control" id="priority" name="priority" min="1" value="1">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-plus me-1"></i>Add Shortlink
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Shortlinks Table -->
        <div class="admin-card">
            <div class="card-header">
                <h5><i class="fas fa-list me-2"></i>Shortlinks Management</h5>
            </div>
            <div class="card-body">
                <?php if (!empty($shortlinks)): ?>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>Reward</th>
                                <th>Views</th>
                                <th>Priority</th>
                                <th>API Key</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($shortlinks as $shortlink): ?>
                            <tr>
                                <td><?= esc($shortlink['id']) ?></td>
                                <td>
                                    <div class="fw-bold"><?= esc($shortlink['name']) ?></div>
                                </td>
                                <td>
                                    <span class="badge bg-success"><?= format_amount($shortlink['reward'], 8) ?> USD</span>
                                </td>
                                <td>
                                    <span class="badge bg-info"><?= number_format($shortlink['total_views']) ?></span>
                                </td>
                                <td>
                                    <span class="badge bg-primary"><?= esc($shortlink['priority']) ?></span>
                                </td>
                                <td>
                                    <code><?= esc(substr($shortlink['api_key'], 0, 10)) ?>...</code>
                                </td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <a href="<?= base_url('admin/shortlinks/edit/' . $shortlink['id']) ?>" 
                                           class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <a href="<?= base_url('admin/shortlinks/delete/' . $shortlink['id']) ?>" 
                                           class="btn btn-sm btn-outline-danger"
                                           onclick="return confirm('Are you sure you want to delete this shortlink? This action cannot be undone.')">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <?php if ($pagination['total_pages'] > 1): ?>
                <nav aria-label="Shortlinks pagination">
                    <ul class="pagination justify-content-center">
                        <?php if ($pagination['current_page'] > 1): ?>
                        <li class="page-item">
                            <a class="page-link" href="<?= current_url() ?>?<?= http_build_query(array_merge($filters, ['page' => $pagination['current_page'] - 1])) ?>">Previous</a>
                        </li>
                        <?php endif; ?>
                        
                        <?php for ($i = 1; $i <= $pagination['total_pages']; $i++): ?>
                        <li class="page-item <?= $i == $pagination['current_page'] ? 'active' : '' ?>">
                            <a class="page-link" href="<?= current_url() ?>?<?= http_build_query(array_merge($filters, ['page' => $i])) ?>"><?= $i ?></a>
                        </li>
                        <?php endfor; ?>
                        
                        <?php if ($pagination['current_page'] < $pagination['total_pages']): ?>
                        <li class="page-item">
                            <a class="page-link" href="<?= current_url() ?>?<?= http_build_query(array_merge($filters, ['page' => $pagination['current_page'] + 1])) ?>">Next</a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </nav>
                <?php endif; ?>
                
                <?php else: ?>
                <div class="text-center py-5">
                    <i class="fas fa-link fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">No shortlinks found</h5>
                    <p class="text-muted">No shortlinks match your search criteria.</p>
                    <a href="<?= base_url('admin/shortlinks/add') ?>" class="btn btn-primary">
                        <i class="fas fa-plus me-1"></i>Add First Shortlink
                    </a>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

