<!--
AC Lite Script - Cryptocurrency Earning Platform
Developed by Altercode (https://altercode.net/)
Copyright (c) 2025 Altercode. All rights reserved.
-->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="favicon" content="<?= base_url('assets/images/favicon.ico') ?>">
    <title><?= $title ?> - Admin Panel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?= base_url('assets/css/style.css') ?>">
    <link rel="stylesheet" href="<?= base_url('assets/css/admin.css') ?>">
</head>
<body class="admin-page">
    <div class="admin-layout">
        <!-- Admin Overlay (Mobile Only) -->
        <div class="admin-overlay" id="adminOverlay"></div>
        
        <!-- Admin Sidebar -->
        <nav class="admin-sidebar" id="adminSidebar">
            <div class="admin-sidebar-header">
                <div class="logo">
                    <i class="fas fa-shield-alt"></i>
                </div>
                <h3>Admin Panel</h3>
            </div>
            
            <div class="admin-sidebar-nav">
                <a href="<?= base_url('admin/dashboard') ?>" class="admin-nav-item <?= (uri_string() == 'admin/dashboard') ? 'active' : '' ?>">
                    <i class="fas fa-tachometer-alt"></i>
                    <span>Dashboard</span>
                </a>
                
                <a href="<?= base_url('admin/users') ?>" class="admin-nav-item <?= (strpos(uri_string(), 'admin/users') === 0) ? 'active' : '' ?>">
                    <i class="fas fa-users"></i>
                    <span>Users</span>
                </a>
                
                <a href="<?= base_url('admin/payouts') ?>" class="admin-nav-item <?= (strpos(uri_string(), 'admin/payouts') === 0) ? 'active' : '' ?>">
                    <i class="fas fa-wallet"></i>
                    <span>Payouts</span>
                </a>
                
                <a href="<?= base_url('admin/settings') ?>" class="admin-nav-item <?= (strpos(uri_string(), 'admin/settings') === 0) ? 'active' : '' ?>">
                    <i class="fas fa-cog"></i>
                    <span>Settings</span>
                </a>
                
                <a href="<?= base_url('admin/faucet') ?>" class="admin-nav-item <?= (strpos(uri_string(), 'admin/faucet') === 0) ? 'active' : '' ?>">
                    <i class="fas fa-faucet"></i>
                    <span>Faucet</span>
                </a>
                
                <a href="<?= base_url('admin/shortlinks') ?>" class="admin-nav-item <?= (strpos(uri_string(), 'admin/shortlinks') === 0) ? 'active' : '' ?>">
                    <i class="fas fa-link"></i>
                    <span>Shortlinks</span>
                </a>
            </div>
            
            <!-- Logout Button in Sidebar -->
            <div class="admin-sidebar-logout">
                <a href="<?= base_url('admin/login/logout') ?>" class="admin-nav-item">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </a>
            </div>
        </nav>
        
        <!-- Admin Main Content -->
        <main class="admin-main">
            <!-- Admin Header -->
            <header class="admin-header">
                <div class="admin-header-left">
                    <button class="admin-sidebar-toggle" id="adminSidebarToggle">
                        <i class="fas fa-bars"></i>
                    </button>
                   
                </div>
                
                <div class="admin-header-right">
                    <div class="admin-user-info">
                        <div class="admin-user-avatar">
                            <i class="fas fa-user"></i>
                        </div>
                        <div class="admin-user-details">
                            <h6><?= $setting['admin_user'] ?></h6>
                            <small>Administrator</small>
                        </div>
                    </div>
                </div>
            </header>
            
            <!-- Admin Content -->
            <div class="admin-content">
                <?= $content ?>
            </div>
        </main>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Admin sidebar toggle
        document.getElementById('adminSidebarToggle').addEventListener('click', function() {
            const sidebar = document.getElementById('adminSidebar');
            const overlay = document.getElementById('adminOverlay');
            const layout = document.querySelector('.admin-layout');
            
            if (window.innerWidth <= 1024) {
                // Tablet and mobile behavior - overlay mode
                sidebar.classList.toggle('mobile-open');
                overlay.classList.toggle('show');
            } else {
                // Desktop behavior - sidebar mode
                sidebar.classList.toggle('collapsed');
                layout.classList.toggle('sidebar-collapsed');
            }
        });
        
        // Close sidebar when overlay is clicked (mobile only)
        document.getElementById('adminOverlay').addEventListener('click', function() {
            const sidebar = document.getElementById('adminSidebar');
            sidebar.classList.remove('mobile-open');
            this.classList.remove('show');
        });
        
        // Handle window resize
        window.addEventListener('resize', function() {
            const sidebar = document.getElementById('adminSidebar');
            const overlay = document.getElementById('adminOverlay');
            const layout = document.querySelector('.admin-layout');
            
            if (window.innerWidth > 1024) {
                // Desktop - remove mobile classes
                sidebar.classList.remove('mobile-open');
                overlay.classList.remove('show');
            } else {
                // Tablet and mobile - remove desktop collapsed classes
                sidebar.classList.remove('collapsed');
                layout.classList.remove('sidebar-collapsed');
            }
        });
    </script>
</body>
</html>
