<div class="admin-users">
    <!-- Users Stats -->
    <div class="row mb-4">
        <div class="col-12 col-lg-6 col-xxl-3 mb-3">
            <div class="admin-stat-card">
                <div class="stat-icon">
                    <i class="fas fa-users"></i>
                </div>
                <div class="stat-content">
                    <h3><?= number_format($stats['total_users']) ?></h3>
                    <p>Total Users</p>
                </div>
            </div>
        </div>
        
        <div class="col-12 col-lg-6 col-xxl-3 mb-3">
            <div class="admin-stat-card">
                <div class="stat-icon">
                    <i class="fas fa-user-plus"></i>
                </div>
                <div class="stat-content">
                    <h3><?= number_format($stats['new_today']) ?></h3>
                    <p>New Today</p>
                </div>
            </div>
        </div>
        
        <div class="col-12 col-lg-6 col-xxl-3 mb-3">
            <div class="admin-stat-card">
                <div class="stat-icon">
                    <i class="fas fa-dollar-sign"></i>
                </div>
                <div class="stat-content">
                    <h3><?= format_amount($stats['total_earned'] / 100000000, 8) ?></h3>
                    <p>Total Earned</p>
                </div>
            </div>
        </div>
        
        <div class="col-12 col-lg-6 col-xxl-3 mb-3">
            <div class="admin-stat-card">
                <div class="stat-icon">
                    <i class="fas fa-list"></i>
                </div>
                <div class="stat-content">
                    <h3><?= number_format($pagination['total_users']) ?></h3>
                    <p>Filtered</p>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Search and Filters -->
    <div class="admin-card mb-4">
        <div class="card-header">
            <h5><i class="fas fa-search me-2"></i>Search & Filters</h5>
        </div>
        <div class="card-body">
            <?= form_open('admin/users', ['method' => 'GET', 'class' => 'row g-3']) ?>
            
            <div class="col-12 col-lg-4 col-md-4">
                <label for="search" class="form-label">Search</label>
                <input type="text" class="form-control" id="search" name="search" 
                       value="<?= esc($filters['search']) ?>" placeholder="Search by email, IP, or ID">
            </div>
            
            
            <div class="col-12 col-lg-2 col-md-2">
                <label for="sort" class="form-label">Sort By</label>
                <select class="form-select" id="sort" name="sort">
                    <option value="id" <?= $filters['sort'] === 'id' ? 'selected' : '' ?>>ID</option>
                    <option value="email" <?= $filters['sort'] === 'email' ? 'selected' : '' ?>>Email</option>
                    <option value="registered_date" <?= $filters['sort'] === 'registered_date' ? 'selected' : '' ?>>Joined</option>
                    <option value="last_active" <?= $filters['sort'] === 'last_active' ? 'selected' : '' ?>>Last Active</option>
                </select>
            </div>
            
            <div class="col-12 col-lg-2 col-md-2">
                <label for="order" class="form-label">Order</label>
                <select class="form-select" id="order" name="order">
                    <option value="DESC" <?= $filters['order'] === 'DESC' ? 'selected' : '' ?>>Descending</option>
                    <option value="ASC" <?= $filters['order'] === 'ASC' ? 'selected' : '' ?>>Ascending</option>
                </select>
            </div>
            
            <div class="col-12 col-lg-2 col-md-2">
                <label class="form-label">&nbsp;</label>
                <div class="d-grid gap-2">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search me-1"></i>Search
                    </button>
                </div>
            </div>
            
            <div class="col-12 col-lg-2 col-md-2">
                <label class="form-label">&nbsp;</label>
                <div class="d-grid gap-2">
                    <a href="<?= base_url('admin/users') ?>" class="btn btn-secondary">
                        <i class="fas fa-refresh me-1"></i>Reset
                    </a>
                </div>
            </div>
            
            <?= form_close() ?>
        </div>
    </div>
    
    <!-- Users Table -->
    <div class="admin-card">
        <div class="card-header">
            <h5><i class="fas fa-users me-2"></i>Users List</h5>
        </div>
        <div class="card-body">
            <?php if (!empty($users)): ?>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>User</th>
                            <th>Referrer</th>
                            <th>Currency</th>
                            <th>Joined</th>
                            <th>Last Active</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($users as $user): ?>
                        <tr>
                            <td><?= esc($user['id']) ?></td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div>
                                        <div class="fw-bold"><?= esc($user['email']) ?></div>
                                        <small class="text-muted"><?= esc($user['ip']) ?></small>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <?php if (!empty($user['ref'])): ?>
                                    <?php if (!empty($user['referrer_email'])): ?>
                                        <div class="d-flex align-items-center">
                                            <div>
                                                <div class="fw-bold"><?= esc($user['referrer_email']) ?></div>
                                                <small class="text-muted">ID: <?= esc($user['ref']) ?></small>
                                            </div>
                                        </div>
                                    <?php else: ?>
                                        <span class="badge bg-warning">ID: <?= esc($user['ref']) ?></span>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <span class="badge bg-primary"><?= esc($user['currency'] ?? 'BTC') ?></span>
                            </td>
                            <td><?= timeSpan($user['registered_date']) ?></td>
                            <td><?= timeSpan($user['last_active']) ?></td>
                            <td>
                                <span class="text-muted">-</span>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            
            <!-- Pagination -->
            <?php if ($pagination['total_pages'] > 1): ?>
            <nav aria-label="Users pagination">
                <ul class="pagination justify-content-center">
                    <?php if ($pagination['current_page'] > 1): ?>
                    <li class="page-item">
                        <a class="page-link" href="<?= current_url() ?>?<?= http_build_query(array_merge($filters, ['page' => $pagination['current_page'] - 1])) ?>">Previous</a>
                    </li>
                    <?php endif; ?>
                    
                    <?php for ($i = 1; $i <= $pagination['total_pages']; $i++): ?>
                    <li class="page-item <?= $i == $pagination['current_page'] ? 'active' : '' ?>">
                        <a class="page-link" href="<?= current_url() ?>?<?= http_build_query(array_merge($filters, ['page' => $i])) ?>"><?= $i ?></a>
                    </li>
                    <?php endfor; ?>
                    
                    <?php if ($pagination['current_page'] < $pagination['total_pages']): ?>
                    <li class="page-item">
                        <a class="page-link" href="<?= current_url() ?>?<?= http_build_query(array_merge($filters, ['page' => $pagination['current_page'] + 1])) ?>">Next</a>
                    </li>
                    <?php endif; ?>
                </ul>
            </nav>
            <?php endif; ?>
            
            <?php else: ?>
            <div class="text-center py-5">
                <i class="fas fa-users fa-3x text-muted mb-3"></i>
                <h5 class="text-muted">No users found</h5>
                <p class="text-muted"><?= !empty($filters['search']) ? 'Try adjusting your search criteria.' : 'There are no users registered yet.' ?></p>
                <?php if (!empty($filters['search'])): ?>
                <a href="<?= base_url('admin/users') ?>" class="btn btn-primary">
                    <i class="fas fa-refresh me-1"></i>Clear Filters
                </a>
                <?php endif; ?>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

