<!--
AC Lite Script - Cryptocurrency Earning Platform
Developed by Altercode (https://altercode.net/)
Copyright (c) 2025 Altercode. All rights reserved.
-->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="favicon" content="<?= base_url('assets/images/favicon.ico') ?>">
    <title><?= $setting['site_name'] ?> - Earn Cryptocurrency</title>
    <link rel="icon" href="<?= base_url('assets/images/favicon.ico') ?>" type="image/x-icon">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&family=Poppins:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?= base_url('assets/css/style.css') ?>">
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-light light-nav">
        <div class="container">
            <a class="navbar-brand light-brand" href="#">
                <?= $setting['site_name'] ?>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="#how-it-works">How It Works</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#withdrawals">Withdrawals</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#faq">FAQ</a>
                    </li>
                    <li class="nav-item">
                        <a class="btn nav-link light-btn-nav text-light" href="#login">
                            <i class="fas fa-rocket me-1"></i>Get Started
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero Section with Login -->
    <section class="hero-section" id="login">
        <div class="hero-background">
            <div class="floating-elements">
                <div class="element element-1"></div>
                <div class="element element-2"></div>
                <div class="element element-3"></div>
                <div class="element element-4"></div>
                <div class="element element-5"></div>
            </div>
        </div>
        <div class="container">
            <div class="row align-items-center min-vh-100">
                <div class="col-lg-6">
                    <div class="hero-content">
                        <h1 class="hero-title">
                            Earn <span class="gradient-text">Free Crypto</span><br>
                            Every Day
                        </h1>
                        <p class="hero-subtitle">
                            Srart earning cryptocurrency today through our secure faucet system. 
                            No investment required - just your time and participation!
                        </p>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="login-card">
                        <div class="login-header">
                            <div class="login-icon">
                                <img src="<?= base_url('assets/images/currency/' . strtolower($setting['currency']) . '.png') ?>" alt="Logo" width="100%">
                            </div>
                            <h3>Start Earning Now</h3>
                            <p>Enter your <?= $setting['microwallet'] ?> email to begin earning cryptocurrency instantly</p>
                            <div class="alert alert-info">
                                <i class="fas fa-exclamation-circle"></i>
                                <strong>Note:</strong> You must have a <?= $setting['microwallet'] == 'faucetpay' ? '<a href="https://altercode.net/goto/faucetpay" target="_blank">FaucetPay</a>' : '<a href="https://altercode.net/goto/hspay" target="_blank">Hspay</a>' ?> account to claim from the faucet.
                            </div>
                        </div>
                        <form class="login-form" id="loginForm" action="<?= base_url('/auth/login') ?>" method="post">
                            <?= session()->getFlashdata('msg') ?>
                            <?= csrf_field() ?>
                            <div class="form-group">
                                <label for="email">Email Address</label>
                                <div class="input-wrapper">
                                    <i class="fas fa-envelope"></i>
                                    <input type="email" id="email" class="form-control light-input" name="email" placeholder="your.email@example.com" required>
                                </div>
                            </div>
                            <button type="submit" class="btn light-btn-primary w-100">
                                <i class="fas fa-play me-2"></i>
                                Start Earning Crypto
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Home Top Ad -->
    <?php if (!empty($setting['home_top_ad'])): ?>
    <div class="container my-4">
        <div class="text-center">
            <?= $setting['home_top_ad'] ?>
        </div>
    </div>
    <?php endif; ?>

    <!-- How It Works Section -->
    <section class="how-it-works-section" id="how-it-works">
        <div class="container">
            <div class="section-header text-center">
                <h2 class="section-title">
                    How to <span class="gradient-text">Start Earning</span>
                </h2>
                <p class="section-subtitle">Simple steps to begin your cryptocurrency earning journey</p>
            </div>
            <div class="row g-4">
                <div class="col-lg-3 col-md-6">
                    <div class="step-card">
                        <div class="step-number">1</div>
                        <div class="step-icon">
                            <i class="fas fa-user-plus"></i>
                        </div>
                        <h4>Sign Up</h4>
                        <p>Enter your email address to create your account instantly. No password required!</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="step-card">
                        <div class="step-number">2</div>
                        <div class="step-icon">
                            <i class="fas fa-tasks"></i>
                        </div>
                        <h4>Complete Tasks</h4>
                        <p>Choose from faucet claims, shortlink missions, or referral activities based on your preference.</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="step-card">
                        <div class="step-number">3</div>
                        <div class="step-icon">
                            <i class="fas fa-coins"></i>
                        </div>
                        <h4>Earn Crypto</h4>
                        <p>Watch your crypto balance grow with each completed task. Track your progress in real-time.</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="step-card">
                        <div class="step-number">4</div>
                        <div class="step-icon">
                            <i class="fas fa-wallet"></i>
                        </div>
                        <h4>Withdraw</h4>
                        <p>Cash out your earnings to your crypto wallet. Low minimum withdrawal amounts.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Withdrawal Proof Section -->
    <section class="withdrawal-proof-section" id="withdrawals">
        <div class="container">
            <div class="section-header text-center">
                <h2 class="section-title">
                    Recent <span class="gradient-text">Withdrawals</span> Proof
                </h2>
                <p class="section-subtitle">Real withdrawals made by our users</p>
            </div>
            
            <!-- Withdrawal Proof Table -->
            <div class="withdrawal-table-container">
                <div class="table-header">
                    <h4><i class="fas fa-wallet me-2"></i>Latest Withdrawals</h4>
                    <span class="verified-indicator">
                        <i class="fas fa-check-circle"></i>
                        Completed Payments
                    </span>
                </div>
                
                <?php if (!empty($withdrawals)): ?>
                <div class="table-responsive">
                    <table class="withdrawal-table">
                        <thead>
                            <tr>
                                <th>User</th>
                                <th>Amount</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($withdrawals as $withdrawal): ?>
                            <tr>
                                <td>
                                    <div class="user-info">
                                        <div class="user-avatar">
                                            <i class="fas fa-user"></i>
                                        </div>
                                        <span class="user-email">****<?= substr($withdrawal['address'], 4) ?></span>
                                    </div>
                                </td>
                                <td>
                                    <div class="amount-info">
                                        <img src="<?= base_url('assets/images/currency/' . strtolower($withdrawal['currency']) . '.png') ?>" alt="<?= $withdrawal['currency'] ?>" class="currency-icon-small">
                                        <span class="amount-value"><?= format_amount($withdrawal['amount_currency'], 8) ?> <?= $withdrawal['currency'] ?></span>
                                    </div>
                                </td>
                                <td>
                                    <span class="withdrawal-date"><?= timeSpan($withdrawal['time_stamp']) ?></span>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <?php else: ?>
                <div class="text-center text-muted py-5">
                    <i class="fas fa-wallet fa-3x mb-3"></i>
                    <p>No withdrawals yet. Be the first to withdraw!</p>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <!-- FAQ Section -->
    <section class="faq-section" id="faq">
        <div class="container">
            <div class="section-header text-center">
                <h2 class="section-title">
                    Frequently Asked <span class="gradient-text">Questions</span>
                </h2>
                <p class="section-subtitle">Everything you need to know about earning crypto</p>
            </div>
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="accordion light-accordion" id="faqAccordion">
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faq1">
                                    <i class="fas fa-question-circle me-2"></i>
                                    How can I earn?
                                </button>
                            </h2>
                            <div id="faq1" class="accordion-collapse collapse show" data-bs-parent="#faqAccordion">
                                <div class="accordion-body">
                                    You can earn crypto by completing tasks such as faucet claims, shortlink missions, and referral bonuses. The more you participate, the higher your earning potential.
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq2">
                                    <i class="fas fa-shield-alt me-2"></i>
                                    How will I get paid?
                                </button>
                            </h2>
                            <div id="faq2" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                                <div class="accordion-body">
                                    Payment is sent to your <?= $setting['microwallet'] ?> account instantly after completing a task, no need to request withdrawal.
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq3">
                                    <i class="fas fa-wallet me-2"></i>
                                    How much can I earn?
                                </button>
                            </h2>
                            <div id="faq3" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                                <div class="accordion-body">
                                    Your daily earnings depend on your activity level. The more you participate, the higher your earning potential.
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Home Bottom Ad -->
    <?php if (!empty($setting['home_bottom_ad'])): ?>
    <div class="container my-4">
        <div class="text-center">
            <?= $setting['home_bottom_ad'] ?>
        </div>
    </div>
    <?php endif; ?>

    <!-- Footer -->
    <footer class="light-footer">
        <div class="container">
            <div class="footer-bottom">
                <div class="row">
                    <div class="col-md-6 text-center text-md-start">
                        <p>copyright &copy; <?= date('Y') ?>  <?= $this->data['setting']['site_name'] ?>. All rights reserved.</p>
                    </div>
                    <div class="col-md-6 text-md-end text-center">
                        <p>Powered by <a href="https://altercode.net/" target="_blank">Altercode</a></p>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="script.js"></script>
</body>
</html>