<!--
AC Lite Script - Cryptocurrency Earning Platform
Developed by Altercode (https://altercode.net/)
Copyright (c) 2025 Altercode. All rights reserved.
-->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="favicon" content="<?= base_url('assets/images/favicon.ico') ?>">
    <title><?= esc($title) ?> - <?= esc($site_name) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .maintenance-container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            padding: 60px 40px;
            text-align: center;
            max-width: 600px;
            width: 90%;
            animation: fadeInUp 0.8s ease-out;
        }
        
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .maintenance-icon {
            font-size: 4rem;
            color: #667eea;
            margin-bottom: 30px;
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.05); }
            100% { transform: scale(1); }
        }
        
        .maintenance-title {
            color: #333;
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 20px;
        }
        
        .maintenance-message {
            color: #666;
            font-size: 1.2rem;
            line-height: 1.6;
            margin-bottom: 40px;
        }
        
        .countdown {
            background: #f8f9fa;
            border-radius: 15px;
            padding: 30px;
            margin: 30px 0;
            border: 2px dashed #dee2e6;
        }
        
        .countdown-text {
            color: #495057;
            font-size: 1.1rem;
            margin-bottom: 20px;
        }
        
        .refresh-btn {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            color: white;
            padding: 15px 30px;
            border-radius: 50px;
            font-size: 1.1rem;
            font-weight: 600;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-block;
        }
        
        .refresh-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
            color: white;
        }
        
        .auto-refresh {
            color: #6c757d;
            font-size: 0.9rem;
            margin-top: 20px;
        }
        
        @media (max-width: 768px) {
            .maintenance-container {
                padding: 40px 20px;
                margin: 20px;
            }
            
            .maintenance-title {
                font-size: 2rem;
            }
            
            .maintenance-message {
                font-size: 1rem;
            }
        }
    </style>
</head>
<body>
    <div class="maintenance-container">
        <div class="maintenance-icon">
            <i class="fas fa-tools"></i>
        </div>
        
        <h1 class="maintenance-title"><?= esc($site_name) ?></h1>
        <h2 class="maintenance-title" style="font-size: 1.8rem; color: #667eea;">Under Maintenance</h2>
        
        <div class="maintenance-message">
            <?= esc($maintenance_message) ?>
        </div>
        
        <div class="countdown">
            <div class="countdown-text">
                <i class="fas fa-clock me-2"></i>
                We'll be back online shortly
            </div>
            <div id="countdown" class="h4 text-primary mb-0">Checking...</div>
        </div>
        
        <a href="javascript:location.reload()" class="refresh-btn">
            <i class="fas fa-sync-alt me-2"></i>
            Refresh Page
        </a>
        
        <div class="auto-refresh">
            <i class="fas fa-info-circle me-1"></i>
            This page will automatically refresh every 30 seconds
        </div>
    </div>

    <script>
        // Auto refresh every 30 seconds
        setTimeout(function() {
            location.reload();
        }, 30000);
        
        // Countdown timer (just for visual effect)
        let countdown = 30;
        const countdownElement = document.getElementById('countdown');
        
        function updateCountdown() {
            countdownElement.textContent = `Auto-refresh in ${countdown} seconds`;
            countdown--;
            
            if (countdown < 0) {
                countdown = 30;
            }
        }
        
        updateCountdown();
        setInterval(updateCountdown, 1000);
    </script>
</body>
</html>
