<div class="container-fluid">
            <div class="main-content-area">
                <!-- Dashboard Header -->
                <div class="dashboard-header">
                    <h1 class="dashboard-title">Dashboard</h1>
                    <p class="dashboard-subtitle">Welcome to <?= $setting['site_name'] ?> - Your crypto earning hub</p>
                </div>

                <!-- Dashboard Top Ad -->
                <?php if (!empty($setting['dashboard_top_ad'])): ?>
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="text-center">
                            <?= $setting['dashboard_top_ad'] ?>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <!-- Welcome Section -->
                <div class="welcome-section">
                    <div class="welcome-card">
                        <div class="welcome-content">
                            <div class="welcome-icon">
                               <i class="fas fa-user fs-1 text-light"></i>
                            </div>
                            <div class="welcome-text">
                                <h2 class="welcome-title">Welcome back </h2>
                                <p class="welcome-message">Ready to earn some cryptocurrency? Choose from the options below to start your earning journey and discover amazing opportunities.</p>
                            </div>
                        </div>
                        <div class="welcome-actions">
                            <?php if($setting['faucet_status'] == 'on'){ ?>
                                <button class="btn btn-primary welcome-btn" onclick="window.location.href='<?= base_url('member/faucet') ?>'">
                                    <i class="fas fa-faucet me-2"></i>
                                    Claim Faucet
                                </button>
                            <?php } ?>
                            <?php if($setting['shortlink_status'] == 'on'){ ?>
                                <button class="btn btn-outline-primary welcome-btn" onclick="window.location.href='<?= base_url('member/shortlinks') ?>'">
                                    <i class="fas fa-link me-2"></i>
                                    Visit Shortlinks
                                </button>
                            <?php } ?>
                        </div>
                    </div>
                </div>

                <div class="quick-actions">
                    <h2 class="section-title">Quick Actions</h2>
                    <div class="actions-grid">
                        <?php if($setting['faucet_status'] == 'on'){ ?>
                        <a href="<?= site_url('member/faucet') ?>" class="action-card">
                            <div class="action-icon">
                                <i class="fas fa-faucet"></i>
                            </div>
                            <h3>Claim Faucet</h3>
                            <p>Earn free crypto every hour</p>
                        </a>
                        <?php } ?>
                        <?php if($setting['shortlink_status'] == 'on'){ ?>
                        <a href="<?= site_url('member/shortlinks') ?>" class="action-card">
                            <div class="action-icon">
                                <i class="fas fa-link"></i>
                            </div>
                            <h3>Complete Links</h3>
                            <p>Earn by visiting shortlinks</p>
                        </a>
                        <?php } ?>
                        <?php if($setting['ref_bonus'] > 0){ ?>
                        <a href="<?= site_url('member/referral') ?>" class="action-card">
                            <div class="action-icon">
                                <i class="fas fa-users"></i>
                            </div>
                            <h3>Invite Friends</h3>
                            <p>Earn from referrals</p>
                        </a>
                        <?php } ?>
                    </div>
                </div>

                <!-- Recent Activity -->
                <div class="recent-activity">
                    <h2 class="section-title">Recent Activity</h2>
                    <div class="activity-list" id="activityList">
                        <?php if(!empty($payments)){ foreach($payments as $payment){ ?>
                            <div class="activity-item">
                                <div class="activity-icon">
                                    <i class="fas fa-faucet"></i>
                                </div>
                                <div class="activity-content">
                                    <h4><?= $payment['type'] ?> Payment</h4>
                                    <p>You earned <?= format_amount($payment['amount_currency'], 8) ?> <?= $payment['currency'] ?></p>
                                    <small><?= timeSpan($payment['time_stamp']) ?></small>
                                </div>
                            </div>
                        <?php } }else{ ?>
                            <div class="activity-item">
                                <div class="activity-icon">
                                    <i class="fas fa-faucet"></i>
                                </div>
                                <div class="activity-content">
                                    <h4>No Activity</h4>
                                    <p>You have not earned any cryptocurrency yet</p>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>

                <!-- Dashboard Bottom Ad -->
                <?php if (!empty($setting['dashboard_bottom_ad'])): ?>
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="text-center">
                            <?= $setting['dashboard_bottom_ad'] ?>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>