<div class="container-fluid">
    <div class="main-content-area">
        <!-- Faucet Header -->
        <div class="dashboard-header">
            <h1 class="dashboard-title"> Faucet - <?= $currencyName ?> (<?= $selectedCurrency ?>)</h1>
            <p class="dashboard-subtitle">Claim free crypto every hour</p>
        </div>

        <!-- Faucet Top Ad -->
        <?php if (!empty($setting['faucet_top_ad'])): ?>
        <div class="row mb-4">
            <div class="col-12">
                <div class="text-center">
                    <?= $setting['faucet_top_ad'] ?>
                </div>
            </div>
        </div>
        <?php endif; ?>
        
        <?php if (session()->getFlashdata('msg')): ?>
        <div class="row mb-3">
            <div class="col-12">
                <?= session()->getFlashdata('msg') ?>
            </div>
        </div>
        <?php endif; ?>

        <!-- Faucet Info Cards -->
        <div class="faucet-info-cards">
            <div class="info-card">
                <div class="info-icon">
                    <i class="fas fa-coins"></i>
                </div>
                <div class="info-content">
                    <h3 class="info-value"><?= format_amount($rewardAmountCurrency, 8) ?> <?= $selectedCurrency ?></h3>
                    <p class="info-label">Amount to Claim</p>
                </div>
            </div>
            
            <div class="info-card">
                <div class="info-icon">
                    <i class="fas fa-clock"></i>
                </div>
                <div class="info-content">
                    <h3 class="info-value" id="timeLeft" data-timer="<?= $timeLeft ?>"><?= $timeLeftFormatted ?></h3>
                    <p class="info-label">Time Left</p>
                </div>
            </div>
            
            <div class="info-card">
                <div class="info-icon">
                    <i class="fas fa-faucet"></i>
                </div>
                <div class="info-content">
                    <h3 class="info-value"><?= $claimsLeft ?>/<?= $setting['faucet_limit'] ?></h3>
                    <p class="info-label">Claims left</p>
                </div>
            </div>
        </div>

        <!-- Faucet Claim Section -->
        <div class="faucet-claim-section">
            <div class="claim-card">
                <div class="claim-header">
                    <h2>Claim Your Reward</h2>
                    <p class="claim-description">Click claim to receive your free crypto</p>
                </div>
                
                <div class="claim-form">
                    <?php if ($canClaim): ?>
                    <form action="<?= base_url('member/faucet/claim') ?>" method="POST">
                        <?= csrf_field() ?>
                        <?= $captcha ?>
                        <!-- Faucet Square Ad -->
                        <?php if (!empty($setting['faucet_square_ad'])): ?>
                        <div class="row mb-4">
                            <div class="col-12">
                                <div class="text-center">
                                    <?= $setting['faucet_square_ad'] ?>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                        <div class="claim-actions">
                            <button type="submit" class="btn btn-primary btn-claim">
                                <i class="fas fa-faucet"></i>
                                <span>Claim Now</span>
                            </button>
                        </div>
                    </form>
                    <?php else: ?>
                    <div class="claim-actions">
                        <button class="btn btn-secondary btn-claim" id="claimButton" disabled>
                            <i class="fas fa-clock"></i>
                            <span>Wait</span>
                        </button>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Faucet Bottom Ad -->
        <?php if (!empty($setting['faucet_bottom_ad'])): ?>
        <div class="row mb-4">
            <div class="col-12">
                <div class="text-center">
                    <?= $setting['faucet_bottom_ad'] ?>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>