<div class="container-fluid">
    <div class="main-content-area">
        <!-- Referral Header -->
        <div class="dashboard-header">
            <h1 class="dashboard-title">Referral Program</h1>
            <p class="dashboard-subtitle">Invite friends and earn <?= $setting['ref_bonus'] ?>% of their earnings forever</p>
        </div>

        <!-- Referral Top Ad -->
        <?php if (!empty($setting['ref_top_ad'])): ?>
        <div class="row mb-4">
            <div class="col-12">
                <div class="text-center">
                    <?= $setting['ref_top_ad'] ?>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Referral Stats -->
        <div class="referral-stats">
            <div class="stat-card">
                <div class="stat-icon">
                    <i class="fas fa-users"></i>
                </div>
                <div class="stat-content">
                    <h3 class="stat-value" id="totalReferrals"><?= $totalReferrals ?></h3>
                    <p class="stat-label">Total Referrals</p>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon">
                    <i class="fas fa-percentage"></i>
                </div>
                <div class="stat-content">
                    <h3 class="stat-value"><?= $setting['ref_bonus'] ?>%</h3>
                    <p class="stat-label">Commission Rate</p>
                </div>
            </div>
        </div>

        <!-- Referral Link -->
        <div class="referral-link-section">
            <h2 class="section-title">Your Referral Link</h2>
            <div class="referral-link-card">
                <div class="referral-link-input">
                    <input type="text" class="form-control" id="referralLink" value="<?= site_url('?r=' . $this->data['user']['id']) ?>" readonly>
                    <button class="btn btn-primary" onclick="copyReferralLink()">
                        <i class="fas fa-copy"></i> Copy
                    </button>
                </div>
                <p class="referral-note">Share this link with your friends to start earning commissions</p>
            </div>
        </div>

        <!-- Referral List -->
        <div class="referral-list">
            <h2 class="section-title">Recent Referrals</h2>
            <div class="referrals-table">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Username</th>
                                <th>Join Date</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody id="referralsTableBody">
                            <?php if (empty($referrals)): ?>
                            <tr>
                                <td colspan="5" class="text-center text-muted">No referrals yet</td>
                            </tr>
                            <?php else: ?>
                                <?php foreach ($referrals as $referral): ?>
                                <?php
                                // Mask email for privacy - strip first 4 letters
                                $email = $referral['email'];
                                $emailParts = explode('@', $email);
                                $username = $emailParts[0];
                                $domain = $emailParts[1];
                                
                                $maskedUsername = str_repeat('*', 4) . substr($username, 4);
                                $maskedEmail = $maskedUsername . '@' . $domain;
                                ?>
                                <?php
                                // Check if user is active (last_active within a week)
                                $lastActive = strtotime($referral['last_active']);
                                $oneWeekAgo = strtotime('-1 week');
                                $isActive = $lastActive > $oneWeekAgo;
                                ?>
                                <tr>
                                    <td><?= esc($maskedEmail) ?></td>
                                    <td><?= date('M d, Y', strtotime($referral['registered_date'])) ?></td>
                                    <td>
                                        <?php if ($isActive): ?>
                                            <span class="badge bg-success">Active</span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary">Inactive</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Referral Bottom Ad -->
        <?php if (!empty($setting['ref_bottom_ad'])): ?>
        <div class="row mb-4">
            <div class="col-12">
                <div class="text-center">
                    <?= $setting['ref_bottom_ad'] ?>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>