<div class="container-fluid">
    <div class="main-content-area">
        <!-- Shortlinks Header -->
        <div class="dashboard-header">
            <h1 class="dashboard-title">Shortlinks - <?= $currencyName ?> (<?= $selectedCurrency ?>)</h1>
            <p class="dashboard-subtitle">Complete shortlinks to earn cryptocurrency</p>
        </div>

        <!-- Shortlink Top Ad -->
        <?php if (!empty($setting['sl_top_ad'])): ?>
        <div class="row mb-4">
            <div class="col-12">
                <div class="text-center">
                    <?= $setting['sl_top_ad'] ?>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Totals Section -->
        <div class="faucet-info-cards">
            <div class="info-card">
                <div class="info-icon">
                                <i class="fas fa-link"></i>
                            </div>
                <div class="info-content">
                    <h3 class="info-value" id="totalShortlinks"><?= count($shortlink) ?></h3>
                    <p class="info-label">Available Shortlinks</p>
                            </div>
                        </div>
            
            <div class="info-card">
                <div class="info-icon">
                    <i class="fas fa-coins"></i>
                    </div>
                <div class="info-content">
                    <h3 class="info-value" id="totalEarnings"><?= format_amount($total_reward / getprice($currencyName), 8) ?> <?= $selectedCurrency ?></h3>
                    <p class="info-label">Total Earnings Available</p>
                            </div>
                        </div>
            
            <div class="info-card">
                <div class="info-icon">
                    <img src="<?= base_url('assets/images/currency/' . strtolower($selectedCurrency) . '.png') ?>" alt="<?= $selectedCurrency ?>" class="currency-icon">
                    </div>
                <div class="info-content">
                    <h3 class="info-value" id="totalCurrency"><?= $selectedCurrency ?></h3>
                    <p class="info-label">Currency</p>
                </div>
            </div>
        </div>

        <!-- Shortlink Square Ad -->
        <?php if (!empty($setting['sl_square_ad'])): ?>
        <div class="row mb-4">
            <div class="col-12">
                <div class="text-center">
                    <?= $setting['sl_square_ad'] ?>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Shortlinks Section -->
        <div class="shortlinks-section">
            <h2 class="section-title">Available Shortlinks</h2>
            <div class="shortlinks-list">
                <?php if (empty($shortlink)): ?>
                <div class="text-center text-muted py-4">
                    <p>No shortlinks available at the moment.</p>
                    </div>
                <?php else: ?>
                    <div class="row g-3">
                        <?php foreach ($shortlink as $link): ?>
                        <?php 
                        $remainingViews = $link['view'] - (!empty($link_data[$link['id']]) ? $link_data[$link['id']] : 0);
                        $canStart = $remainingViews > 0;
                        ?>
                        <div class="col-12 col-md-6 col-xxl-4">
                            <div class="shortlink-item" data-id="<?= $link['id'] ?>">
                                <div class="text-center mb-3">
                                    <h3 class="shortlink-title"><?= esc($link['name']) ?></h3>
                        </div>
                                <div class="d-flex gap-2 justify-content-center m-2">
                                    <span class="badge bg-success p-2"><i class="fas fa-coins"></i> <?= format_amount($link['reward'] / getprice($currencyName), 8) ?> <?= $selectedCurrency ?></span>
                                    <span class="badge bg-primary p-2"><i class="fas fa-eye"></i> <?= $link['view'] - $remainingViews ?>/<?= $link['view'] ?> views</span>
                    </div>
                    <div class="shortlink-actions">
                                    <?php if ($canStart): ?>
                                    <a href="<?= base_url('member/shortlink/' . strtolower($selectedCurrency) . '/view/' . $link['id']) ?>" class="btn btn-primary shortlink-btn primary">
                            <i class="fas fa-play"></i>
                            <span>Start</span>
                                    </a>
                                    <?php else: ?>
                                    <button class="btn btn-success shortlink-btn" disabled>
                                        <i class="fas fa-check"></i>
                                        <span>Completed</span>
                        </button>
                                    <?php endif; ?>
                    </div>
                </div>
                    </div>
                        <?php endforeach; ?>
                        </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Shortlink Bottom Ad -->
        <?php if (!empty($setting['sl_bottom_ad'])): ?>
        <div class="row mb-4">
            <div class="col-12">
                <div class="text-center">
                    <?= $setting['sl_bottom_ad'] ?>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>