<!--
AC Lite Script - Cryptocurrency Earning Platform
Developed by Altercode (https://altercode.net/)
Copyright (c) 2025 Altercode. All rights reserved.
-->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="favicon" content="<?= base_url('assets/images/favicon.ico') ?>">
    <title><?= $title ?> - <?= $setting['site_name'] ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&family=Poppins:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?= base_url('assets/css/style.css') ?>">
    <link rel="stylesheet" href="<?= base_url('assets/css/app.css') ?>">
</head>
<body>

    <!-- Top Navigation -->
    <nav class="navbar navbar-expand-lg navbar-light fixed-top light-nav" id="topNavbar">
        <div class="container-fluid">
            <div class="d-flex align-items-center">
                <button class="btn sidebar-toggle-btn me-3" id="sidebarToggle">
                    <i class="fas fa-bars"></i>
                </button>
            </div>
            
            <div class="d-flex align-items-center">
                <div class="dark-mode-toggle me-3">
                    <button class="btn dark-mode-btn" id="darkModeToggle">
                        <i class="fas fa-moon"></i>
                    </button>
                </div>
            </div>
        </div>
    </nav>

    <!-- Mobile Overlay -->
    <div class="mobile-overlay" id="mobileOverlay"></div>

    <!-- Dashboard Sidebar -->
    <div class="dashboard-sidebar" id="dashboardSidebar">
        <div class="sidebar-header">
            <div class="sidebar-brand ms-2">
                <span class="brand-text"><?= $setting['site_name'] ?></span>
            </div>
        </div>
        
        <div class="sidebar-menu" id="sidebarMenu">
            <div class="menu-section">
                <h6 class="menu-title">Main</h6>
                <a href="<?= base_url('member/dashboard') ?>" class="sidebar-item">
                    <i class="fas fa-tachometer-alt"></i>
                    <span>Dashboard</span>
                </a>
                <a href="<?= base_url('member/referral') ?>" class="sidebar-item">
                    <i class="fas fa-users"></i>
                    <span>Referral</span>
                </a>
                <?php if($setting['faucet_status'] == 'on'){ ?>
                    <a href="<?= base_url('member/faucet') ?>" class="sidebar-item">
                        <i class="fas fa-faucet"></i>
                        <span>Faucet</span>
                    </a>
                <?php } ?>
                <?php if($setting['shortlink_status'] == 'on'){ ?>
                    <a href="<?= base_url('member/shortlinks') ?>" class="sidebar-item">
                        <i class="fas fa-link"></i>
                        <span>Shortlink</span>
                    </a>
                <?php } ?>
            </div>
            
            <div class="menu-section">
                <h6 class="menu-title">Support</h6>
                <a href="<?= base_url('#faq') ?>" class="sidebar-item">
                    <i class="fas fa-question-circle"></i>
                    <span>FAQ</span>
                </a>
                <a href="<?= base_url('logout') ?>" class="sidebar-item">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </a>
            </div>
        </div>
        
        <div class="sidebar-footer">
            <div class="user-info">
                <div class="user-avatar">
                    <i class="fas fa-user"></i>
                </div>
                <div class="user-details">
                    <span class="user-name">member</span>
                    <small class="user-status"><?= $user['email'] ?></small>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <section class="main-content">
        <?= $content ?>
    </section>

    <!-- Footer -->
    <footer class="light-footer" id="mainFooter">
        <div class="container">
            <div class="footer-bottom">
                <div class="row">
                    <div class="col-12 col-lg-6 text-center">
                        <p>copyright &copy; <?= date('Y') ?> <?= $setting['site_name'] ?>.</p>
                    </div>
                    <div class="col-12 col-lg-6 text-center">
                        <p>Powered by <a href="https://altercode.net/" target="_blank">Altercode</a></p>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <!-- Shortlink Modal -->
    <div class="modal fade" id="shortlinkModal" tabindex="-1" aria-labelledby="shortlinkModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content shortlink-modal">
                <div class="modal-header">
                    <h5 class="modal-title" id="shortlinkModalLabel">Complete Shortlink Task</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="shortlink-info">
                        <div class="shortlink-preview">
                            <i class="fas fa-link"></i>
                            <span id="modalShortlinkTitle">Loading...</span>
                        </div>
                        <div class="reward-info">
                            <span class="reward-amount" id="modalRewardAmount">$0.00</span>
                            <span class="reward-label">Reward</span>
                        </div>
                    </div>
                    <div class="timer-container">
                        <div class="timer-circle">
                            <div class="timer-progress" id="timerProgress"></div>
                            <div class="timer-text" id="timerText">60</div>
                        </div>
                        <p class="timer-label">Please wait for the timer to complete</p>
                    </div>
                    <div class="shortlink-actions">
                        <button class="btn light-btn-primary w-100" id="completeBtn" disabled>
                            <i class="fas fa-check me-2"></i>
                            Complete Task
                        </button>
                        <button class="btn btn-outline-secondary w-100 mt-2" id="visitBtn">
                            <i class="fas fa-external-link-alt me-2"></i>
                            Visit Link
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div id="detect"></div>
    <script>
      const detect = document.querySelector("#detect");
      
      async function detectAdBlock() {
        let adBlockEnabled = false
        const googleAdUrl = 'https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js'
        try {
          await fetch(new Request(googleAdUrl)).catch(_ => adBlockEnabled = true)
        } catch (e) {
          adBlockEnabled = true;
        } finally {
            if(adBlockEnabled === true){
                window.location.href = "<?= site_url('/member/adblock') ?>";
            }
          console.log(`AdBlock Enabled: ${adBlockEnabled}`);
        }
      }
      detectAdBlock();
  </script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?= base_url('assets/js/app.js') ?>"></script>
</body>
</html>
